var Timer = function(tab, expireTime) {
    this.tab = tab;
    this.expireTime = expireTime;
};

Timer.prototype.isExpired = function() {
    return +(new Date()) > this.expireTime;
};

Timer.prototype.remainsMinutes = function() {
    return Math.round((this.expireTime - (new Date()).getTime()) / 60000);
};


var KTimer = {
    addTimer: function(tab, timeout, callback) {
        if (!tab || typeof tab.id === 'undefined') {
            return false;
        }

        //this.timers[tab.id] = new Timer(tab, timeout);
        var expireTime = (new Date()).getTime() + timeout * 60000;
        var timer = new Timer(tab, expireTime);
        var kv = {};
        kv[tab.id.toString()] = timer;


        chrome.storage.local.get('timers', function(value) {
            if (typeof value === 'undefined' || typeof value.timers === 'undefined') {
                value = {timers: {}};
            }
            value.timers[tab.id.toString()] = timer;
            chrome.storage.local.set(value, function() {
                chrome.browserAction.setBadgeText({text: timeout.toString(), tabId: tab.id});
                if (typeof callback === 'function') {
                    callback(timer);
                }
            });
        });

        return true;
    },
    getTimer: function(tab, callback) {
        chrome.storage.local.get('timers', function(value) {
            callback = callback || function() {};
            if (typeof value === 'undefined' || typeof value.timers === 'undefined') {
                callback();
                return;
            }
            var timers = value.timers;

            if (typeof timers[tab.id.toString()] === 'undefined') {
                callback();
                return;
            }
            var timerData = timers[tab.id.toString()];
            callback(new Timer(timerData.tab, timerData.expireTime));
        });
    },
    removeTimer: function(tab, callback) {
        var tabId = typeof tab === 'number' ? tab : tab.id;
        chrome.storage.local.get('timers', function(value) {
            callback = callback || function() {};
            if (typeof value === 'undefined'  || typeof value.timers === 'undefined') {
                callback();
                return;
            }
            var timers = value.timers;

            if (typeof timers[tabId.toString()] === 'undefined') {
                callback();
                return;
            }
            delete value.timers[tabId.toString()];
            chrome.storage.local.set(value, function() {
                callback();
            });
        });
    },
    getAll: function(callback) {
        chrome.storage.local.get('timers', function(value) {
            callback = callback || function() {};
            if (typeof value === 'undefined') {
                callback();
                return;
            }
            var timers = value.timers;

            var result = {};
            for (var id in timers) {
                if (timers.hasOwnProperty(id)) {
                    var item = timers[id];
                    result[id] = new Timer(item.tab, item.expireTime);
                }
            }

            callback(result);
        });
    }
};